/*** 1.   ũƮ ***/

SELECT seq
	, NEWID() AS txt
	, CASE WHEN seq = 1 THEN 0 WHEN seq = 2 THEN NULL ELSE number END AS value 
INTO TB_Null
FROM (SELECT a.number, ROW_NUMBER() OVER (ORDER BY a.number) AS seq 
	 FROM master..spt_values a, master..spt_values b
	 WHERE a.type = 'P'
	 AND b.type = 'P'
	 AND a.number BETWEEN 1 AND 1000
	 AND b.number BETWEEN 1 AND 1000 
) c 

CREATE INDEX NIDX01_Null ON TB_Null ( value ) 
GO


/*** 2. [AS-IS] SQL    ȹ ***/

SELECT seq, txt 
FROM TB_Null
WHERE ISNULL(value,0) = 0
GO


/*** 6. [TO-BE]   ***/

SELECT seq, txt 
FROM TB_Null
WHERE value IS NULL OR value = 0
GO